/*
 * QrfeTagInterface.cpp
 *
 *  Created on: 30.07.2009
 *      Author: stefan.detter
 */


#include "../inc/tag/QrfeTagInterface.h"

QrfeTagInterface::QrfeTagInterface(QString tagId, QrfeTagManipulatorInterface* reader, QObject* parent)
	: QObject(parent)
	, m_tagId(tagId)
	, m_reader(reader)
{
	m_manufacturer = "-";
	m_model = "-";
	m_userMemSize = -1;
	m_serialNumber = -1;
	m_hasSerialNumber = false;
}


QrfeTagInterface::~QrfeTagInterface()
{
}

QString QrfeTagInterface::tagId()
{
	return m_tagId;
}

QByteArray QrfeTagInterface::tagIdBytes()
{
	bool ok;
	QByteArray bytes = QrfeGlobal::stringToBytes(m_tagId, &ok);
	if(!ok)
		return QByteArray();
	return bytes;
}

QString QrfeTagInterface::manufacturer()
{
	return m_manufacturer;
}

QString QrfeTagInterface::model()
{
	return m_model;
}

QString QrfeTagInterface::userMemSize()
{
	if(m_userMemSize >= 0)
		return QString::number(m_userMemSize) + " Bytes";
	else
		return "-";
}

bool QrfeTagInterface::hasSerialNr()
{
	return m_hasSerialNumber;
}

QString QrfeTagInterface::serialNr()
{
	if(m_serialNumber >= 0)
		return "0x" + QString("%1").arg(m_serialNumber, 8, 16, QChar('0')).toUpper();
	else
		return "-";
}

QrfeReaderInterface* QrfeTagInterface::readerInterface()
{
	return m_reader->getReaderInterface();
}

QrfeTagManipulatorInterface* QrfeTagInterface::tagManipulatorInterface()
{
	return m_reader;
}
